

/******************************************************************************************************
 **                                                                                                  **
 **                     Ex7.2 : Print String (for ET-DISPLAY 8x32RED)                                **
 **                     Use : Dot-Matrix(8x8=4 digit) #LDM1088A ,Drive #Max7219                      **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         :   AVR Easy Mega 328 (ET-CPU DISPLAY8x32)                                   **
 **                     :   X-TAL : 16 MHz                                                           ** 
 **                                                                                                  **
 **  Editor/Compiler    :   Arduino 1.8.1                                                            **
 **                                                                                                  **                   
 **  Port Interface    :   Arduino Mega328 PIN                        Device Interface               **
 **                         ----------------------                     --------------                **                      
 **  Dot-Matrix         :   Pin D10-OUT (PB2)                           CS/Load-Max7219              **
 **                         Pin D11-OUT (PB3)                           DIN-Max7219                  **
 **                         Pin D12-OUT (PB4)                           CLK-Max7219K                 **
 **                                                                                                  **                                                                                                 **
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   7/December/2018                                                          ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

// MAX7219 commands:
#define CMD_NOOP   0
#define CMD_DIGIT0 1
#define CMD_DIGIT1 2
#define CMD_DIGIT2 3
#define CMD_DIGIT3 4
#define CMD_DIGIT4 5
#define CMD_DIGIT5 6
#define CMD_DIGIT6 7
#define CMD_DIGIT7 8
#define CMD_DECODEMODE  9
#define CMD_INTENSITY   10
#define CMD_SCANLIMIT   11
#define CMD_SHUTDOWN    12
#define CMD_DISPLAYTEST 15

#define NUM_MAX      4    //Number Max7219 4 Ship

/************ Define Pin **************/

//--Dot Matrix Pin for Max7219----
#define CS_PIN       10
#define DIN_PIN      11
#define CLK_PIN      12

                               //Colum      0       1        2        3
static byte ScrBuf[8][4] = {   //Position  DSP0   -DSP1    -DSP2   -DSP3       
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0  ---Row0(A0) 
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0
                    {0,0,0,0},             
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0}    //data   D8-D0   D8-D0   D8-D0   D8-D0   ---Row7(A7)
                  };           //Ex Font   'A'


/****************************************************************
 *                              Data Font                       *
 **************************************************************** 
 * //-First Byte of font[0] is NumByte / Charecter
 * -First Byte of font[0] is Type Font 1= Cuttom font,2=Full font
 * -First byte of Charecter is bit wide of Charecter     
 * -Font Read Hor Colum [ D7...D0] 
 * -Plot First Byte  from Up to Down   
 * -Font Close Left  
 * https://www.riyas.org/2013/12/online-led-matrix-font-generator-with.html  
 * -----------------------------------------  
 *      8  4  2  1  8  4  2  1 ----->Weight
 *     D7 D6 D5 D4 D3 D2 D1 D0 ----->Data 1Byte
 *   -----------------------------
 * 0|   0  #  #  #  0  0  0  0   = 0x70    ----->    ,Ex Font0 size 5x7           
 * 1|   #  0  0  0  #  0  0  0   = 0x88
 * 2|   #  0  0  0  #  0  0  0   = 0x88
 * 3|   #  0  0  0  #  0  0  0   = 0x88
 * 4|   #  0  0  0  #  0  0  0   = 0x88
 * 5|   #  0  0  0  #  0  0  0   = 0x88
 * 6|   0  #  #  #  0  0  0  0   = 0x70  
 * 7|   0  0  0  0  0  0  0  0   = 0x00
 *  
 *  '0' = {5,0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00} 
*/  

//---------------------Font Text Bold 6x7(WxH)----------------------------------
//----Font Close Left and  close Over Side ----------
// !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}~ 
//----------------------------------------------------------

const unsigned char Font_Bold6x7[] PROGMEM ={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,// space Ascii Start 0x20   
0x60,0xf0,0xf0,0x60,0x60,0x00,0x60,0x00,// !
0xd8,0xd8,0x50,0x00,0x00,0x00,0x00,0x00,// "
0x6c,0x6c,0xfe,0x6c,0xfe,0x6c,0x6c,0x00,// #
0x30,0x78,0xc0,0x78,0x0c,0xf8,0x30,0x00,// $
0xc0,0xcc,0x18,0x30,0x60,0xcc,0x0c,0x00,// %
0x78,0xcc,0x78,0x50,0xca,0xcc,0x7e,0x00,// &
0x60,0x60,0xc0,0x00,0x00,0x00,0x00,0x00,// A'=39
0x30,0x60,0xc0,0xc0,0xc0,0x60,0x30,0x00,// (
0xc0,0x60,0x30,0x30,0x30,0x60,0xc0,0x00,// )
0x00,0x48,0x30,0xfc,0x30,0x48,0x00,0x00,// *
0x00,0x30,0x30,0xfc,0x30,0x30,0x00,0x00,// +
0x00,0x00,0x00,0x00,0x00,0x60,0x60,0xc0,// , 
0x00,0x00,0x00,0xfc,0xfc,0x00,0x00,0x00,// -
0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,0x00,// .
0x04,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00,// /
0x78,0xcc,0xcc,0xcc,0xcc,0xcc,0x78,0x00,// 0   //Ascii =0x30
0x30,0xf0,0x30,0x30,0x30,0x30,0xfc,0x00,// 1
0x78,0xcc,0x0c,0x78,0xc0,0xc0,0xfc,0x00,// 2
0x78,0xcc,0x0c,0x38,0x0c,0xcc,0x78,0x00,// 3
0x18,0x38,0x58,0x98,0xfc,0x18,0x18,0x00,// 4
0xfc,0xc0,0xc0,0xf8,0x0c,0xcc,0x78,0x00,// 5
0x78,0xcc,0xc0,0xf8,0xcc,0xcc,0x78,0x00,// 6
0xfc,0x0c,0x0c,0x18,0x30,0x30,0x30,0x00,// 7
0x78,0xcc,0xcc,0x78,0xcc,0xcc,0x78,0x00,// 8
0x78,0xcc,0xcc,0x7c,0x0c,0xcc,0x78,0x00,// 9
0x00,0xc0,0xc0,0x00,0x00,0xc0,0xc0,0x00,// :
0x00,0x00,0x00,0xc0,0xc0,0x00,0x40,0x80,// ;
0x18,0x30,0x60,0xc0,0x60,0x30,0x18,0x00,// <
0x00,0x00,0xf8,0xf8,0x00,0xf8,0xf8,0x00,// =
0xc0,0x60,0x30,0x18,0x30,0x60,0xc0,0x00,// >
0x78,0xcc,0x0c,0x38,0x30,0x00,0x30,0x00,// ?
0x78,0xcc,0xdc,0xdc,0xdc,0xc0,0x78,0x00,//@
0x78,0xcc,0xcc,0xfc,0xcc,0xcc,0xcc,0x00,// A
0xf8,0xcc,0xcc,0xf8,0xcc,0xcc,0xf8,0x00,// B
0x78,0xcc,0xc0,0xc0,0xc0,0xcc,0x78,0x00,// C
0xf8,0xcc,0xcc,0xcc,0xcc,0xcc,0xf8,0x00,// D
0xfc,0xc0,0xc0,0xf8,0xc0,0xc0,0xfc,0x00,// E
0xfc,0xc0,0xc0,0xf8,0xc0,0xc0,0xc0,0x00,// F
0x78,0xcc,0xc0,0xdc,0xcc,0xcc,0x78,0x00,// G
0xcc,0xcc,0xcc,0xfc,0xcc,0xcc,0xcc,0x00,// H
0xf0,0x60,0x60,0x60,0x60,0x60,0xf0,0x00,// I
0x3c,0x18,0x18,0x18,0xd8,0xd8,0x70,0x00,// J
0xcc,0xcc,0xd8,0xf0,0xd8,0xcc,0xcc,0x00,// K
0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xfc,0x00,// L
0x84,0xcc,0xfc,0xd4,0xc4,0xc4,0xc4,0x00,// M
0xcc,0xec,0xfc,0xdc,0xcc,0xcc,0xcc,0x00,// N
0x78,0xcc,0xcc,0xcc,0xcc,0xcc,0x78,0x00,// O
0xf8,0xcc,0xcc,0xf8,0xc0,0xc0,0xc0,0x00,// P
0x78,0xcc,0xcc,0xcc,0xdc,0x78,0x1c,0x00,// Q
0xf8,0xcc,0xcc,0xf8,0xd8,0xcc,0xcc,0x00,// R
0x78,0xcc,0xc0,0x78,0x0c,0xcc,0x78,0x00,// S
0xfc,0xb4,0x30,0x30,0x30,0x30,0x30,0x00,// T
0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0x78,0x00,// U
0xcc,0xcc,0xcc,0xcc,0xcc,0x78,0x30,0x00,// V
0xc4,0xc4,0xd4,0xd4,0xf4,0xfc,0x48,0x00,// W
0xcc,0xcc,0x78,0x30,0x78,0xcc,0xcc,0x00,// X
0xcc,0xcc,0xcc,0x78,0x30,0x30,0x30,0x00,// Y
0xfc,0xcc,0x18,0x30,0x60,0xcc,0xfc,0x00,// Z
0xf0,0xc0,0xc0,0xc0,0xc0,0xc0,0xf0,0x00,// [
0x80,0xc0,0x60,0x30,0x18,0x0c,0x04,0x00,// \backslah=92
0xf0,0x30,0x30,0x30,0x30,0x30,0xf0,0x00,// ]
0x20,0x70,0xd8,0x88,0x00,0x00,0x00,0x00,// ^
0x00,0x00,0x00,0x00,0x00,0xfc,0xfc,0x00,// _
0x60,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,// 'A = 96
0x00,0x00,0x70,0x18,0x78,0xd8,0x78,0x00,// a
0xc0,0xc0,0xf0,0xd8,0xd8,0xd8,0xf0,0x00,// b
0x00,0x00,0x78,0xc0,0xc0,0xc0,0x78,0x00,// c
0x18,0x18,0x78,0xd8,0xd8,0xd8,0x78,0x00,// d
0x00,0x00,0x70,0xd8,0xf8,0xc0,0x78,0x00,// e
0x30,0x68,0x60,0xf0,0x60,0x60,0xf0,0x00,// f
0x00,0x00,0x78,0xd8,0xd8,0x78,0x18,0x70,// g
0xc0,0xc0,0xf0,0xd8,0xd8,0xd8,0xd8,0x00,// h
0x60,0x00,0xe0,0x60,0x60,0x60,0xf0,0x00,// i
0x18,0x00,0x18,0x18,0x18,0xd8,0xd8,0x70,// j
0xc0,0xc0,0xd8,0xd8,0xf0,0xd8,0xd8,0x00,// k
0xe0,0x60,0x60,0x60,0x60,0x60,0xf0,0x00,// l
0x00,0x00,0xf8,0xfc,0xd4,0xd4,0xd4,0x00,// m
0x00,0x00,0xf0,0xd8,0xd8,0xd8,0xd8,0x00,// n
0x00,0x00,0x70,0xd8,0xd8,0xd8,0x70,0x00,// o
0x00,0x00,0xf0,0xd8,0xd8,0xf0,0xc0,0xc0,// p
0x00,0x00,0x78,0x98,0x98,0x78,0x18,0x18,// q
0x00,0x00,0xf0,0xd8,0xc0,0xc0,0xc0,0x00,// r
0x00,0x00,0x78,0xc0,0x70,0x18,0xf0,0x00,// s
0x60,0x60,0xf0,0x60,0x60,0x68,0x30,0x00,// t
0x00,0x00,0xd8,0xd8,0xd8,0xd8,0x78,0x00,// u
0x00,0x00,0xd8,0xd8,0xd8,0x50,0x20,0x00,// v
0x00,0x00,0xd4,0xd4,0xd4,0xfc,0x78,0x00,// w
0x00,0x00,0xd8,0xd8,0x70,0xd8,0xd8,0x00,// x
0x00,0x00,0xd8,0xd8,0xd8,0x78,0x18,0x70,// y
0x00,0x00,0xf8,0x18,0x70,0xc0,0xf8,0x00,// z
0x38,0x60,0x60,0xc0,0x60,0x60,0x38,0x00,// {
0xc0,0xc0,0xc0,0x00,0xc0,0xc0,0xc0,0x00,// |
0xe0,0x30,0x30,0x18,0x30,0x30,0xe0,0x00,// }
0x00,0x00,0x00,0x74,0xd8,0x00,0x00,0x00 // ~

};

//---------------------Font Clear ScrBuf -------------------------         
                        
const unsigned char BClr[] PROGMEM = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}; //data Clear Buffer



/*************************************************************************
 **    Function : Sent Command+Data 2Byte(16Bit) to Max7219 4-Ship      **
 *************************************************************************/            
  
void SendCmdAll(byte cmd, byte data)
{
  int dp ;
  
  digitalWrite(CS_PIN, LOW);
  
  for(dp=0 ; dp< NUM_MAX ; dp++)                 //Loop 4 round for Max7219 4 Ship
   {
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, cmd) ; //Shift command 8 bit byte High(D15-D8)
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, data); //Shift Data 8 bit byte Low(D7-D0) 
   }

  digitalWrite(CS_PIN, LOW);
  digitalWrite(CS_PIN, HIGH);
}



/****************************************************************
 **       Function : Refress Screen All (4 Display=8x32 Dot)   **
 ****************************************************************/       

void RefreshAll() 
{
  char rw,dp  ;
  
  //------------- Refresh Screen All --------------------------
  
  for (rw = 0; rw < 8 ; rw++)  //Loop Scan 8 Row  Start A0-A7 
   {
    digitalWrite(CS_PIN, LOW);
    
    for(dp = 3 ; dp >= 0 ; dp--) //Loop NUM_MAX=4 (0-3)
     {
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, CMD_DIGIT0 + rw)   ; //Shift cmm 8bit byte High (Row Address Start Row 0(Ver.))
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, ScrBuf[rw][dp])    ; //Shift data 8bit byte Low (Sent Serial data Start Buffer[row0][Colum3]
     }
    digitalWrite(CS_PIN, LOW);
    digitalWrite(CS_PIN, HIGH);                                 //Latch Data to Display
   }

}


/**************************************************************************************************************
 **                           Function : Plot data to Screen Buffer                                          **      
 **************************************************************************************************************           
 **  Paramiter :                                                                                             **
 **              dsp = Position dsp buffer 0-3 for keep data                                                 **                                                      
 **       *name_font = Name Table font                                                                       **      
 **                                                                                                          **
 **************************************************************************************************************/
 
void PlotDot(char dsp, const unsigned char *name_font)
{
  byte dt ;
  char col,row ;
    
   
    for(row=0;row<8;row++)                  //Loop Number Byte Data of 1 Charecter row 0-7
     {
        dt = pgm_read_byte(name_font+row) ;   //Read Data 1 Byte of font from 8 Byte
        ScrBuf[row][dsp] = dt             ;   //update Data 1 byte of Charecter to buffer colume Dsp 4 colum 
       
    } //for row

} //End Show Number



/********************************************************************************************
 **  Function : Print Charecter to Screen Buffer each 1 Charecter(Table Font)              **      
 ********************************************************************************************           
 **  Paramiter :                                                                           **
 **              dsp = Position dsp buffer 0-3 for keep data                               **                                                      
 **                ch = Ascii Charector Start 0x20(Space) or Decimal 0-9                   **              
 **       *name_font = Name Table font                                                     **      
 **                                                                                        **
 **                                                                                        **
 ********************************************************************************************/
 
void PrintChar(unsigned char dsp,char ch, const unsigned char *name_font)
{
   byte dt  ;
   int row,arry ;

  if((ch>=0)&&(ch<10))  //if value ch is decimal 0-9
     ch = ch+0x10  ;    //Cal Position Table AScii Number0-9 
  else                  //if value ch if ASCII 
     ch = ch-0x20;     //Cal Position Row Ascii Table of Charecter

   
   arry = ch * 8  ;  //Cal Position Start Array Table of Charector
   
   for(row=0;row<8;row++)                         //Loop Number Byte Data of 1 Charecter row 0-7
    {
       dt = pgm_read_byte(name_font+row+arry) ;   //Read Data 1 Byte of font from 8 Byte
       ScrBuf[row][dsp] = dt                  ;   //update Data 1 byte of Charecter to buffer colume Dsp 4 colum 
       
   } //for row 
  
}


/*********************************************************************************
 **     Function : Print String max 4 charecter to Screen Buffer (Table Font)   **      
 *********************************************************************************           
 **   Paramiter :                                                               **                                                 
 **        *str = Message by use Table Font max 4 Charector                     **      
 **       *name_font = Name Table Font                                          **
 *********************************************************************************/
 
void PrintStr( char *str , const unsigned char *name_font )
{
  char cnt_str,ch,dsp;
  unsigned char num_char ;
  
     num_char = strlen(str)                                ;    //Read Leng of String
    
    if(num_char>4)                                        // Check String limit 4 Charector
      num_char = 4 ; 

     dsp = num_char-1  ;
     
    for(cnt_str=0; cnt_str<num_char; cnt_str++)     
     {
       ch = str[cnt_str]                                   ;    // Find Position Charecter for Plot 
       PrintChar(dsp,ch,name_font )                        ;
       dsp--                                               ;
     }
}  // End


/********************************************************
 **            Function:Initial Max7219                **
 ********************************************************/  
         
void InitMAX7219()
{
  pinMode(DIN_PIN, OUTPUT)         ;   //D11
  pinMode(CLK_PIN, OUTPUT)         ;   //D13
  pinMode(CS_PIN, OUTPUT)          ;   //D10
  digitalWrite(CS_PIN, HIGH)       ;
  digitalWrite(CLK_PIN, LOW)       ;  //****************
    
  SendCmdAll(CMD_DISPLAYTEST, 0)   ;  //Set Display Normal Mode
  SendCmdAll(CMD_SCANLIMIT, 7)     ;  //Set Scan 8 digit is 100 HZ 
  SendCmdAll(CMD_DECODEMODE, 0)    ;
  SendCmdAll(CMD_INTENSITY, 15)    ; //Bright Max=15 ,Min=0
  SendCmdAll(CMD_SHUTDOWN, 0)      ;

  RefreshAll()                     ; 
  SendCmdAll(CMD_SHUTDOWN,1)       ;

}



// ########################## Setup ####################################

void setup() 
{
  InitMAX7219();
}
 
// ########################## Main Program #############################

void loop()
{ 
 
  while(1)
  {
  
       PrintStr("abcd",Font_Bold6x7) ;
       RefreshAll()                  ;
       delay(2000)                   ;
     
       PrintStr("1234",Font_Bold6x7) ;
       RefreshAll()                  ;
       delay(2000)                   ;

       PrintStr(" 567",Font_Bold6x7) ;
       RefreshAll()                  ;
       delay(2000)                   ;
  
 
  }  
   
}  // end void







